import { Link, useLocation } from 'react-router-dom'
import { Brain, History, Calendar, Facebook, Instagram, Send, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="layout">
      <header className="header">
        <div className="header-content">
          <div className="logo">
            <Brain className="logo-icon" size={32} />
            <span className="logo-text">ПсихоКонсультация</span>
          </div>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              <History className="nav-icon" size={20} />
              <span>История</span>
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              <Calendar className="nav-icon" size={20} />
              <span>Запись</span>
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-wrapper">
          <div className="footer-main">
            <div className="footer-col">
              <div className="footer-brand">
                <div className="footer-logo">
                  <Brain className="footer-logo-icon" size={28} />
                  <h2>ПсихоКонсультация</h2>
                </div>
                <p>Профессиональная психологическая помощь онлайн и офлайн. Индивидуальный подход к каждому клиенту с 2010 года.</p>
                <div className="footer-social">
                  <a href="#" className="social-link" aria-label="Facebook">
                    <Facebook className="social-icon" size={20} />
                  </a>
                  <a href="#" className="social-link" aria-label="Instagram">
                    <Instagram className="social-icon" size={20} />
                  </a>
                  <a href="#" className="social-link" aria-label="Telegram">
                    <Send className="social-icon" size={20} />
                  </a>
                </div>
              </div>
            </div>
            <div className="footer-col">
              <h4>Услуги</h4>
              <ul>
                <li><Link to="/book">Записаться на консультацию</Link></li>
                <li><a href="#">Индивидуальная терапия</a></li>
                <li><a href="#">Семейная терапия</a></li>
                <li><a href="#">Групповые сеансы</a></li>
                <li><a href="#">Онлайн-консультации</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Темы</h4>
              <ul>
                <li><a href="#">Стресс и тревога</a></li>
                <li><a href="#">Отношения</a></li>
                <li><a href="#">Карьера</a></li>
                <li><a href="#">Депрессия</a></li>
                <li><a href="#">Саморазвитие</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Контакты</h4>
              <div className="footer-contacts">
                <div className="contact-item">
                  <Phone className="contact-icon" size={18} />
                  <div>
                    <span>+7 (495) 123-45-67</span>
                    <span className="contact-label">Круглосуточно</span>
                  </div>
                </div>
                <div className="contact-item">
                  <Mail className="contact-icon" size={18} />
                  <span>info@psychoconsult.ru</span>
                </div>
                <div className="contact-item">
                  <MapPin className="contact-icon" size={18} />
                  <span>Москва, ул. Психологическая, 10</span>
                </div>
                <div className="contact-item">
                  <Clock className="contact-icon" size={18} />
                  <span>Пн-Вс: 9:00 - 21:00</span>
                </div>
              </div>
            </div>
          </div>
          <div className="footer-divider"></div>
          <div className="footer-bottom">
            <p>&copy; 2025 ПсихоКонсультация. Все права защищены.</p>
            <div className="footer-links-bottom">
              <a href="#">Политика конфиденциальности</a>
              <a href="#">Пользовательское соглашение</a>
              <a href="#">Карта сайта</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

